/*
 * This file contains all the functions related to the Waveform Screen for Channel 1
 * */

#include <math.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include "inc/hw_memmap.h"
#include "inc/hw_gpio.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "driverlib/udma.h"
#include "driverlib/rom.h"
#include "grlib/grlib.h"
#include "grlib/widget.h"
#include "grlib/canvas.h"
#include "grlib/checkbox.h"
#include "grlib/container.h"
#include "grlib/pushbutton.h"
#include "grlib/radiobutton.h"
#include "grlib/slider.h"

#include "lcd_tools/Kentec320x240x16_ssd2119_spi.h"
#include "lcd_tools/touch.h"

#include "DisplayWaveformCh1.h"
#include "InitializeFunctions.h"

//variable for zooming the displed waveform
short zoom_scale = 1;
// variable for storing the y-coordiante of the printing screen
int y_axis[MAX_SAMPLES], y_axis_zoomed[MAX_SAMPLES];

// Buttons in the waveform channel 1 screen
RectangularButton(backHomeButWFS, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 80,
                  195, 80, 44, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL,
                  BUT_PRESS, 0, BUT_TEXT_COLOR, &g_sFontCm20, "HOME", 0, 0, 0,
                  0, backHomeButWFSFunc);

RectangularButton(nextCh2But, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 240,
                  195, 80, 44, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL,
                  BUT_PRESS, 0, BUT_TEXT_COLOR, &g_sFontCm20, "NEXT", 0, 0, 0,
                  0, nextCh2ButFunc);

RectangularButton(backFAButWFS, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 0, 195,
                  80, 44, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, BUT_PRESS,
                  0, BUT_TEXT_COLOR, &g_sFontCm20, "BACK", 0, 0, 0, 0,
                  backFAButWFSFunc);

// Buttons for zoomin and zoomout in the waveform screen (NOT VISIBLE on the display)

RectangularButton(zoomIncBut, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 0, 30, 50,
                  100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, zoomIncButFun);

RectangularButton(zoomDecBut, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 269, 30,
                  50, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, zoomDecButFun);

// call back function for Back to home button in waveform channel 1 screen
void backHomeButWFSFunc(tWidget *psWidget)
{
    WidgetRemove((tWidget*) &backHomeButWFS);
    WidgetRemove((tWidget*) &backFAButWFS);
    WidgetRemove((tWidget*) &zoomIncBut);
    WidgetRemove((tWidget*) &zoomDecBut);

    clr_scrn_total();

    homeScreen();
}

// call back function for Back to frequency and amplitude select screen - 1 button in waveform channel 1 screen
void backFAButWFSFunc(tWidget *psWidget)
{
    WidgetRemove((tWidget*) &backHomeButWFS);
    WidgetRemove((tWidget*) &backFAButWFS);
    WidgetRemove((tWidget*) &zoomIncBut);
    WidgetRemove((tWidget*) &zoomDecBut);

    clr_scrn_total();

    freqAmpSelScreenCh1();
}

// call back function for going to next waveform i.e channel 2 in waveform ch1 screen
void nextCh2ButFunc(tWidget *psWidget)
{
    WidgetRemove((tWidget*) &backHomeButWFS);
    WidgetRemove((tWidget*) &backFAButWFS);
    WidgetRemove((tWidget*) &zoomIncBut);
    WidgetRemove((tWidget*) &zoomDecBut);
    WidgetRemove((tWidget*) &nextCh2But);

    clr_scrn_total();

    displayWaveScreenCh2();
}

// display waveform function for channel - 1
void displayWaveScreenCh1()
{
    screenChar = 'd';
    clr_scrn_total();

    includeZoomFunc();

    WidgetAdd(WIDGET_ROOT, (tWidget*) &backHomeButWFS);
    WidgetPaint((tWidget* )&backHomeButWFS);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &backFAButWFS);
    WidgetPaint((tWidget* )&backFAButWFS);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &nextCh2But);
    WidgetPaint((tWidget* )&nextCh2But);

    makeRect(&FuncGenRect, 0, 0, 319, 14, RECT_FOREGROUND_COLOR,
             "FUNCTION GENERATOR");
    makeRect(&WFCh1Rect, 160, 194, 239, 239, RECT_FOREGROUND_COLOR,
             "Ch1 Wave");
}

//all the zooming work
// call back function for zooming in channel 1
void zoomIncButFun(tWidget *psWidget)
{
    zoom_scale = zoom_scale * 2;
    if (zoom_scale >= 16)
    {
        zoom_scale = 16; // maximum zoom limit is 16
    }
    print_waveform_ch1();
}

// call back function for zooming out channel 1
void zoomDecButFun(tWidget *psWidget)
{
    zoom_scale = zoom_scale / 2;
    if (zoom_scale <= 1)
    {
        zoom_scale = 1; // minimum zoom limit is 1
    }
    print_waveform_ch1();
}

// for including zoom in and zoom out functionality buttons
void includeZoomFunc()
{
    WidgetAdd(WIDGET_ROOT, (tWidget*) &zoomIncBut);
    WidgetPaint((tWidget* )&zoomIncBut);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &zoomDecBut);
    WidgetPaint((tWidget* )&zoomDecBut);
}

// printing the exact waveform in channel 1 display screen
void print_waveform_ch1()
{

    clear_screen_grid();

    float *wave;
    switch (ch1)
    {
    case 'n':
        wave = sine;
        break;
    case 's':
        wave = square;
        break;
    case 't':
        wave = tri;
        break;
    }

    int scale_factor = 20;
    uint32_t y_origin = 110;

    y_axis[0] = y_origin + (int) ((scale_factor) * (amp * wave[0]));
    y_axis_zoomed[0] = y_axis[0];

    GrContextForegroundSet(&sContext, ClrCyan);
    GrLineDrawH(&sContext, 0, 1, y_axis[0]);

    for (int i = 1; i < 319; i++)
    {
        int wave_point = (((int) (i * freq)) % MAX_SAMPLES);
        y_axis[i] = y_origin
                + (int) ((scale_factor) * (amp * wave[wave_point]));
    }

    for (int i = 1; i < 319; i++)
    {
        y_axis_zoomed[i] = y_axis[i / zoom_scale];

        GrLineDrawV(&sContext, i, y_axis_zoomed[i - 1], y_axis_zoomed[i]);
        GrLineDrawH(&sContext, i, i + 1, y_axis_zoomed[i]);
    }

    tRectangle Rect_amp,Rect_freq;

    // printing freq and amp of the waveform which is displayed
    printAmpStr(ampStr,&amp);
    makeRect(&Rect_amp,250,15, 319,30,RECT_FREQAMP_COLOR,ampStr);


    printFreqStr(freqStr,&freq);
    makeRect(&Rect_freq,0,15, 70,30,RECT_FREQAMP_COLOR,freqStr);

}

